/*
Fichier permettant de configurer une carte HC-05 mais également une carte 
 */
#include <SoftwareSerial.h>  
#define HC05_BAUDRATE 38400
#define RN42_BAUDRATE 115200

//   Pin 10 --> Bluetooth TX
//   Pin 11 --> Bluetooth RX
SoftwareSerial bluetooth(10, 11); // RX, TX

void setup()
{
  pinMode(12, OUTPUT);  // pin KEY pour passer en mode commande AT
  digitalWrite(12, HIGH);
  
  Serial.begin(9600);  // Etablie la communication série entre le PC et l'arduino
  Serial.println("Enter AT Command");
  
  bluetooth.begin(HC05_BAUDRATE);  // etablie la communication série entre l'arduino et la carte bluetooth
}


//permet la transmission et reception de n'importe quelle commande AT
void loop()
{
  if(bluetooth.available())  // If the bluetooth sent any characters
  {
    // Send any characters the bluetooth prints to the serial monitor
    Serial.print((char)bluetooth.read());  
  }
  if(Serial.available())  // If stuff was typed in the serial monitor
  {
    // Send any characters the Serial monitor prints to the bluetooth
    bluetooth.print((char)Serial.read());
  }
  // and loop forever and ever!
}

